package com.ekoapp.ekosdk.internal.api.mapper;

import com.ekoapp.ekosdk.internal.api.dto.EkoFollowCountDto;
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity;

public interface EkoFollowCountMapper extends EkoObjectMapper<EkoFollowCountDto, EkoFollowCountEntity> {
    EkoFollowCountMapper MAPPER = dto -> {
        EkoFollowCountEntity followCountEntity = new EkoFollowCountEntity();
        if (dto.getUserId() != null) {
            followCountEntity.setUserId(dto.getUserId());
            followCountEntity.setFollowerCount(dto.getFollowerCount());
            followCountEntity.setFollowingCount(dto.getFollowingCount());
            followCountEntity.setPendingCount(dto.getPendingCount());
        }
        return followCountEntity;
    };
}

