package com.ekoapp.ekosdk.internal.api.mapper

import com.ekoapp.ekosdk.internal.api.dto.EkoPollDto
import com.ekoapp.ekosdk.internal.entity.PollEntity

internal class EkoPollMapper : EkoObjectMapper<EkoPollDto, PollEntity> {

    override fun map(dto: EkoPollDto?): PollEntity {
        return PollEntity()
            .apply {
                pollId = dto!!.pollId
                userId = dto.userId
                question = dto.question
                answers = dto.answers
                answerType = dto.answerType
                status = dto.status
                closedAt = dto.closedAt
                isDeleted = dto.isDeleted
                isVoted = dto.isVoted
                createdAt = dto.createdAt
                updatedAt = dto.updatedAt
            }
    }
}