package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.social.feed.AmityFeedType;
import com.ekoapp.ekosdk.internal.api.dto.EkoFeedDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface EkoPostAndUserMapper extends EkoObjectMapper<EkoPostQueryDto, Void> {

    EkoPostAndUserMapper MAPPER = dto -> {
        EkoFileListPersister.persist(dto.getFiles());
        EkoUserListPersister.persist(dto.getUsers());
        EkoCommunityCategoryListPersister.persist(dto.getCategories());
        EkoCommunityMembershipListPersister.persist(dto.getCommunityUsers());
        EkoCommunityListPersister.persist(dto.getCommunities());
        EkoCommentListPersister.persist(dto.getComments());

        List<EkoPostDto> postChildrenDto = mapPostDtoList(dto.getChildren(), dto.getFeeds());
        EkoPostListPersister.persist(postChildrenDto);

        List<EkoPostDto> postsDto = mapPostDtoList(dto.getPosts(), dto.getFeeds());
        EkoPostListPersister.persist(postsDto);

        EkoFeedListPersister.persist(dto.getFeeds());
        EkoStreamListPersister.persist(dto.getStreams());
        EkoPollPersister.Companion.persist(dto.getPolls());
        return null;
    };

    static List<EkoPostDto> mapPostDtoList(List<EkoPostDto> postDtoList, List<EkoFeedDto> feedDtoList) {
        List<EkoPostDto> newItems = new ArrayList<>(postDtoList);

        Map<String, EkoFeedDto> feedDtoMap = new HashMap<>();
        for (EkoFeedDto feedDto : feedDtoList) {
            feedDtoMap.put(Objects.requireNonNull(feedDto.getFeedId()), feedDto);
        }

        for (EkoPostDto postDto : newItems) {
            String feedId = postDto.getFeedId();
            if (feedId != null && feedDtoMap.get(feedId) != null) {
                postDto.setFeedType(feedDtoMap.get(feedId).getFeedType());
            } else {
                postDto.setFeedType(AmityFeedType.PUBLISHED.getApiKey());
            }
        }
        return newItems;
    }

}
