package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository;
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostDto;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoPostFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoPostFlag;
import com.google.common.collect.FluentIterable;

import java.util.Collections;
import java.util.List;

class EkoPostListPersister extends EkoObjectPersister {

    static void persist(List<EkoPostDto> dtoList) {
        final UserDatabase userDatabase = UserDatabase.get();
        userDatabase.runInTransaction(() -> {
            persistChanges(dtoList, EkoPostMapper.MAPPER, userDatabase.postDao());

            for (EkoPostDto postDto : dtoList) {
                // persist post reaction
                if(postDto.getMyReactions() != null) {
                    final EkoReactionDao reactionDao = userDatabase.reactionDao();
                    reactionDao.deleteByReferenceIdAndUserId(postDto.getPostId(), ReactionReferenceType.POST.getValue(), AmityCoreClient.INSTANCE.getUserId());
                    reactionDao.insert(FluentIterable.from(postDto.getMyReactions())
                            .transform(reactionName -> new ReactionRepository().createMyReaction(
                                    ReactionReferenceType.POST,
                                    postDto.getPostId(),
                                    reactionName)
                            ).toList());
                }

                // persist flag
                final EkoPostFlagDao flagDao = userDatabase.postFlagDao();
                EkoPostFlag postFlag = new EkoPostFlag();
                postFlag.setPostId(postDto.getPostId());
                postFlag.setFlag(postDto.getFlag());

                EkoPostFlag diskFlag = flagDao.getByIdNow(postDto.getPostId());
                if (diskFlag != null) {
                    postFlag.setLocalFlag(diskFlag.getLocalFlag());
                    flagDao.update(postFlag);
                } else {
                    flagDao.insert(postFlag);
                }
            }
        });
    }
}
