package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionAndUserListDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactorDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface EkoReactionMapper extends EkoObjectMapper<EkoReactionAndUserListDto, List<EkoReactionEntity>> {

    EkoReactionMapper MAPPER = dto -> {

        List<EkoUserDto> userDtoList = dto.getUsers();
        Map<String, String> userMap = Maps.newHashMap(); // Map of userId, DisplayName
        for (EkoUserDto userDto : userDtoList) {
            userMap.put(userDto.getUserId(), userDto.getDisplayName());
        }

        List<EkoReactionEntity> reactionList = new ArrayList<>();
        for (EkoReactionDto reactionDto : dto.getReactions()) {
            for (EkoReactorDto reactorDto : reactionDto.getReactors()) {
                EkoReactionEntity reaction = EkoReactionEntity.create(
                        reactorDto.getReactionId(),
                        ReactionReferenceType.Companion.enumOf(reactionDto.getReferenceType()),
                        reactionDto.getReferenceId(),
                        reactorDto.getReactionName(),
                        reactorDto.getUserId(),
                        userMap.get(reactorDto.getUserId()),
                        reactorDto.getCreatedAt(),
                        reactorDto.getUpdatedAt());
                reactionList.add(reaction);
            }
        }

        return reactionList;
    };
}
