package com.ekoapp.ekosdk.internal.api.mapper;

import com.ekoapp.ekosdk.internal.api.dto.EkoStreamDto;
import com.ekoapp.ekosdk.internal.entity.EkoStreamEntity;

public interface EkoStreamEntityMapper extends EkoObjectMapper<EkoStreamDto, EkoStreamEntity> {

    EkoStreamEntityMapper MAPPER = dto -> {
        EkoStreamEntity stream = new EkoStreamEntity();
        stream.setStreamId(dto.getStreamId());
        stream.setTitle(dto.getTitle());
        stream.setDescription(dto.getDescription());
        stream.setMetadata(dto.getMetadata());
        stream.setStatus(dto.getStatus());
        stream.setReconnecting(dto.isReconnecting());
        stream.setUserId(dto.getUserId());
        stream.setThumbnailFileId(dto.getThumbnailFileId());
        stream.setCreatedAt(dto.getCreatedAt());
        stream.setUpdatedAt(dto.getUpdatedAt());
        stream.setWatcherData(dto.getWatcherData());
        stream.setBroadcasterData(dto.getBroadcasterData());
        stream.setRecordings(dto.getRecordings());
        stream.setResolution(dto.getResolution());
        stream.setDeleted(dto.isDeleted());
        return stream;
    };
}
