package com.ekoapp.ekosdk.internal.api.mapper;

import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoUserFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFlag;

import java.util.List;

public class EkoUserListPersister extends EkoObjectPersister {

    public static void persist(List<EkoUserDto> userDtoList) {
        final UserDatabase userDatabase = UserDatabase.get();
        userDatabase.runInTransaction(new Runnable() {
            @Override
            public void run() {
                persistChanges(userDtoList, EkoUserMapper.MAPPER, userDatabase.userDao());
                final EkoUserFlagDao flagDao = userDatabase.userFlagDao();
                for (EkoUserDto userDto : userDtoList) {
                    final EkoUserFlag userFlag = new EkoUserFlag();
                    userFlag.setUserId(userDto.getUserId());
                    userFlag.setFlag(userDto.getFlag());

                    final EkoUserFlag diskFlag = flagDao.getByIdNow(userDto.getUserId());
                    if (diskFlag != null) {
                        userFlag.setLocalFlag(diskFlag.getLocalFlag());
                        flagDao.update(userFlag);
                    } else {
                        flagDao.insert(userFlag);
                    }
                }
            }
        });
    }
}