package com.ekoapp.ekosdk.internal.api.mapper;

import com.ekoapp.ekosdk.UserEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto;

public interface EkoUserMapper extends EkoObjectMapper<EkoUserDto, UserEntity> {

    EkoUserMapper MAPPER = dto -> {
        UserEntity user = new UserEntity();
        user.setUserId(dto.getUserId());
        user.setMid(dto.getMid());
        user.setPath(dto.getPath());
        user.setDisplayName(dto.getDisplayName());
        user.setRoles(dto.getRoles());
        user.setPermissions(dto.getPermissions());
        user.setAvatarFileId(dto.getAvatarFileId());
        user.setAvatarCustomUrl(dto.getAvatarCustomUrl());
        user.setDescription(dto.getDescription());
        user.setFlagCount(dto.getFlagCount());
        user.setMetadata(dto.getMetadata());
        if (dto.isGlobalBan() != null) {
            user.setGlobalBan(dto.isGlobalBan());
        }
        if (dto.isDeleted() != null) {
            user.setDeleted(dto.isDeleted());
        }
        user.setCreatedAt(dto.getCreatedAt());
        user.setUpdatedAt(dto.getUpdatedAt());
        return user;
    };

    @Override
    default UserEntity update(UserEntity objectOnDisk, UserEntity objectToSave) {
        if(objectToSave.getUpdatedAt().isAfter(objectOnDisk.getUpdatedAt())
                || objectToSave.getUpdatedAt().isEqual(objectOnDisk.getUpdatedAt())) {
            return objectToSave;
        }
        return objectOnDisk;
    }
}
