package com.ekoapp.ekosdk.internal.api.socket.call;

import androidx.annotation.NonNull;

import com.amity.socialcloud.sdk.socket.model.SocketRequest;

public class Call<T> {

    @NonNull
    private final SocketRequest request;
    @NonNull
    private final ResponseConverter<T> converter;


    protected Call(@NonNull SocketRequest request, @NonNull ResponseConverter<T> converter) {
        this.request = request;
        this.converter = converter;
    }

    @NonNull
    public SocketRequest getRequest() {
        return request;
    }

    @NonNull
    public ResponseConverter<T> getConverter() {
        return converter;
    }


    public static <T> Call<T> create(@NonNull SocketRequest request, @NonNull ResponseConverter<T> converter) {
        return new Call<>(request, converter);
    }
}
