package com.ekoapp.ekosdk.internal.api.socket.call

import com.amity.socialcloud.sdk.socket.model.SocketResponse
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto
import com.ekoapp.ekosdk.internal.api.mapper.EkoPostAndUserMapper
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.entity.GlobalPostEntity

class GlobalPostQueryConverter : ResponseConverter<EkoPostQueryDto> {

    override fun convert(response: SocketResponse): EkoPostQueryDto {
        val dto = response.getData(EkoPostQueryDto::class.java)
        invalidateCache(dto)
        assignRank(dto)
        EkoPostAndUserMapper.MAPPER.map(dto)
        return dto
    }

    private fun invalidateCache(dto: EkoPostQueryDto) {
        if (dto.paging.previous == null) {
            UserDatabase.get().globalPostDao().deleteAll()
        }
    }

    private fun assignRank(dto: EkoPostQueryDto) {
        val globalPostDao = UserDatabase.get().globalPostDao()
        var rank = globalPostDao.getHighestRank()
        val globalPosts = dto.posts.map {
            rank++
            GlobalPostEntity().apply {
                this.postId = it.postId
                this.pageNumber = 1
                this.rank = rank
            }
        }
        globalPostDao.insert(globalPosts)
    }

}

