package com.ekoapp.ekosdk.internal.api.socket.call;

import com.ekoapp.ekosdk.internal.api.dto.EkoStreamQueryDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoStreamQueryMapper;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.amity.socialcloud.sdk.socket.model.SocketResponse;

public class StreamQueryConverter implements ResponseConverter<EkoStreamQueryDto> {

    @Override
    public EkoStreamQueryDto convert(SocketResponse response) {
        EkoStreamQueryDto dto = response.getData(EkoStreamQueryDto.class);
        softDeleteIfNeeded(dto);
        EkoStreamQueryMapper.MAPPER.map(dto);
        return dto;
    }

    private void softDeleteIfNeeded(EkoStreamQueryDto dto) {
        final boolean isFirstPage = dto.getToken().getPrevious() == null;
        if (isFirstPage) {
            UserDatabase.get().streamDao().softDelete();
        }
    }
}
