package com.amity.socialcloud.sdk.socket

import com.amity.socialcloud.sdk.core.error.AmityError
import com.amity.socialcloud.sdk.core.error.AmityException
import com.amity.socialcloud.sdk.socket.model.SocketResponse

class AmitySocketException private constructor(message: String, cause: Throwable?, code: Int)
    : AmityException(message, cause, code) {

    companion object {
        fun create(message: String, response: SocketResponse): AmitySocketException {
            return AmitySocketException(message, null, response.code)
        }

        fun create(message: String, error: AmityError): AmitySocketException {
            return create(message, error.code)
        }

        fun create(message: String, code: Int): AmitySocketException {
            return AmitySocketException(message, null, code)
        }
    }
}