package com.ekoapp.ekosdk.internal.api.socket.request

import com.amity.socialcloud.sdk.socket.model.SocketRequest

data class ChannelMembershipQueryRequest(val channelId: String,
                                         val roles: List<String>? = null,
                                         val filter: String? = null,
                                         val sortBy: String? = null,
                                         val options: ChannelMembershipQueryOptions? = null,
                                         val search: String? = null) : SocketRequest {
    override fun method(): String {
        return "v3/channel.queryUsers"
    }

    data class ChannelMembershipQueryOptions(val skip: Int? = null,
                                             val limit: Int? = null,
                                             val token: String? = null)
}