package com.ekoapp.ekosdk.internal.api.socket.request

import com.amity.socialcloud.sdk.socket.model.SocketRequest
import com.google.gson.annotations.SerializedName

data class ChannelQueryRequest @JvmOverloads constructor(
        @SerializedName("keyword") val keyword: String? = null,
        val isDeleted: Boolean? = null,
        val types: List<String>? = null,
        val filter: String? = null,
        val tags: List<String>? = null,
        val excludeTags: List<String>? = null,
        val sortBy: String? = null,
        val options: ChannelQueryOptions = ChannelQueryOptions()) : SocketRequest {

    override fun method(): String {
        return "v3/channel.query"
    }

    data class ChannelQueryOptions(var skip: Int? = null,
                                   var limit: Int? = null,
                                   var token: String? = null)
}