package com.ekoapp.ekosdk.internal.api.socket.request

import com.amity.socialcloud.sdk.socket.model.SocketRequest

data class MessageQueryRequest(var channelId: String? = null,
                               var type: String? = null,
                               var isDeleted: Boolean? = null,
                               var parentId: String? = null,
                               var filterByParentId: Boolean? = null,
                               var tags: List<String>? = null,
                               var excludeTags: List<String>? = null,
                               var options: MessageQueryOptions = MessageQueryOptions()) : SocketRequest {
    override fun method(): String {
        return "v3/message.query"
    }

    data class MessageQueryOptions(var after: Int? = null,
                                   var first: Int? = null,
                                   var before: Int? = null,
                                   var last: Int? = null,
                                   var token: String? = null,
                                   var limit: Int? = null,
                                   var skip: Int? = null,
                                   var type: String? = null
    )
}