package com.ekoapp.ekosdk.internal.api.socket.request

import com.amity.socialcloud.sdk.socket.model.SocketRequest

data class SearchChannelMembershipQueryRequest(
    val channelId: String,
    val roles: List<String>? = null,
    val memberships: List<String>? = null,
    val sortBy: String? = null,
    val options: SearchChannelMembershipQueryOptions? = null,
    val search: String? = null
) : SocketRequest {
    override fun method(): String {
        return "v4/channel.queryUsers"
    }

    data class SearchChannelMembershipQueryOptions(
        val skip: Int? = null,
        val limit: Int? = null,
        val token: String? = null
    )
}