package com.ekoapp.ekosdk.internal.api.socket.request

import com.amity.socialcloud.sdk.socket.model.SocketRequest


data class StreamQueryRequest @JvmOverloads constructor(val statuses: List<String>,
                                                        var isDeleted: Boolean,
                                                        var options: StreamQueryOptions = StreamQueryOptions()) : SocketRequest {
    override fun method(): String {
        return "v3/video-streaming.query"
    }

    data class StreamQueryOptions(var limit: Int? = null,
                                  var token: String? = null)
}