package com.ekoapp.ekosdk.internal.api.socket.request

import com.amity.socialcloud.sdk.socket.model.SocketRequest
import com.google.gson.annotations.SerializedName

data class UserQueryRequest @JvmOverloads constructor(@SerializedName("keyword") val keyword: String? = null,
                                                      var sortBy: String? = null,
                                                      var options: UserQueryOptions = UserQueryOptions()) : SocketRequest {
    override fun method(): String {
        return "v3/user.query"
    }

    data class UserQueryOptions(val skip: Int? = null,
                                var limit: Int? = null,
                                var token: String? = null)
}