package com.ekoapp.ekosdk.internal.data.boundarycallback

import androidx.paging.PagedList.BoundaryCallback
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore
import com.ekoapp.core.utils.getCurrentClassAndMethodNames
import com.amity.socialcloud.sdk.log.AmityLog
import io.reactivex.CompletableObserver
import io.reactivex.disposables.Disposable


internal abstract class EkoBoundaryCallback<EKO_OBJECT : Any>(val pageSize: Int) : BoundaryCallback<EKO_OBJECT>(), CompletableObserver {
    val userId: String = SessionLocalDataStore().getActiveUserId()

    abstract fun onFirstLoaded()

    override fun onSubscribe(d: Disposable) {}
    override fun onComplete() {}
    override fun onError(e: Throwable) {
        val TAG = getCurrentClassAndMethodNames()
        AmityLog.tag(TAG).e(e)
    }
}