package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.amity.socialcloud.sdk.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.chat.channel.AmityChannel.Type.Companion.enumOf

class AmityChannelTypesConverter {

    @TypeConverter
    fun jsonToType(json: String): List<AmityChannel.Type> {
        return StringListConverter().stringToStringList(json)?.map { enumOf(it) } ?: listOf()
    }

    @TypeConverter
    fun typeToJson(types: List<AmityChannel.Type>): String {
        return StringListConverter().stringListToString(types.map { it.apiKey })
    }
}