package com.ekoapp.ekosdk.internal.data.converter;

import androidx.room.TypeConverter;

import com.ekoapp.ekosdk.EkoCategoryIds;
import com.amity.socialcloud.sdk.socket.util.EkoGson;

public class EkoCategoriesTypeConverter {

    @TypeConverter
    public EkoCategoryIds stringToEkoCategories(String json) {
        return EkoGson.get().fromJson(json, EkoCategoryIds.class);
    }

    @TypeConverter
    public String ekoCategoriesToString(EkoCategoryIds categories) {
        return EkoGson.get().toJson(categories);
    }
}
