package com.ekoapp.ekosdk.internal.data.converter;

import androidx.room.TypeConverter;

import com.ekoapp.ekosdk.EkoFlag;
import com.amity.socialcloud.sdk.socket.util.EkoGson;

public class EkoFlagTypeConverter {

    @TypeConverter
    public EkoFlag stringToEkoFlag(String json) {
        return EkoGson.get().fromJson(json, EkoFlag.class);
    }

    @TypeConverter
    public String ekoFlagToString(EkoFlag flag) {
        return EkoGson.get().toJson(flag);
    }
}

