package com.ekoapp.ekosdk.internal.data.converter;

import androidx.room.TypeConverter;

import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.amity.socialcloud.sdk.socket.util.EkoGson;

public class EkoLocalFlagTypeConverter {

    @TypeConverter
    public EkoLocalFlag stringToEkoLocalFlag(String json) {
        return EkoGson.get().fromJson(json, EkoLocalFlag.class);
    }

    @TypeConverter
    public String ekoLocalFlagToString(EkoLocalFlag flag) {
        return EkoGson.get().toJson(flag);
    }
}

