package com.ekoapp.ekosdk.internal.data.converter;

import androidx.room.TypeConverter;

import com.amity.socialcloud.sdk.core.permission.AmityPermissions;
import com.amity.socialcloud.sdk.socket.util.EkoGson;

public class EkoPermissionsTypeConverter {

    @TypeConverter
    public AmityPermissions stringToEkoPermissions(String json) {
        return EkoGson.get().fromJson(json, AmityPermissions.class);
    }

    @TypeConverter
    public String ekoPermissionsToString(AmityPermissions permissions) {
        return EkoGson.get().toJson(permissions);
    }
}
