package com.ekoapp.ekosdk.internal.data.converter;

import androidx.room.TypeConverter;

import com.ekoapp.ekosdk.internal.data.model.AmityReactionMap;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.google.gson.reflect.TypeToken;

public class EkoReactionMapConverter {

    @TypeConverter
    public AmityReactionMap stringToStringIntMap(String json) {
        return EkoGson.get().fromJson(json, new TypeToken<AmityReactionMap>(){}.getType());
    }

    @TypeConverter
    public String stringIntMapToString(AmityReactionMap map) {
        return EkoGson.get().toJson(map);
    }

}
