package com.ekoapp.ekosdk.internal.data.converter;

import androidx.room.TypeConverter;

import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.amity.socialcloud.sdk.socket.util.EkoGson;

public class EkoRolesTypeConverter {

    @TypeConverter
    public AmityRoles stringToEkoRoles(String json) {
        return EkoGson.get().fromJson(json, AmityRoles.class);
    }

    @TypeConverter
    public String ekoRolesToString(AmityRoles roles) {
        return EkoGson.get().toJson(roles);
    }
}
