package com.ekoapp.ekosdk.internal.data.converter;

import androidx.room.TypeConverter;

import com.amity.socialcloud.sdk.core.AmityTags;
import com.amity.socialcloud.sdk.socket.util.EkoGson;

public class EkoTagsTypeConverter {

    @TypeConverter
    public AmityTags stringToEkoTags(String json) {
        return EkoGson.get().fromJson(json, AmityTags.class);
    }

    @TypeConverter
    public String ekoTagsToString(AmityTags tags) {
        return EkoGson.get().toJson(tags);
    }
}
