package com.ekoapp.ekosdk.internal.data.converter;

import androidx.room.TypeConverter;

import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.google.common.base.Strings;
import com.google.gson.JsonArray;

public class JsonArrayTypeConverter {

    @TypeConverter
    public JsonArray stringToJsonObject(String json) {
        if (Strings.isNullOrEmpty(json)) {
            return new JsonArray();
        }
        return EkoGson.get().fromJson(json, JsonArray.class);
    }

    @TypeConverter
    public String jsonObjectToString(JsonArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        return EkoGson.get().toJson(jsonArray);
    }
}
