package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.amity.socialcloud.sdk.social.feed.AmityPollAnswer
import com.amity.socialcloud.sdk.socket.util.EkoGson
import com.google.gson.reflect.TypeToken

class PollAnswersConverter {

    @TypeConverter
    fun jsonToAnswers(json: String): List<AmityPollAnswer> {
        return EkoGson.get().fromJson(json, object : TypeToken<List<AmityPollAnswer>>() {}.type)
    }

    @TypeConverter
    fun answersToJson(list: List<AmityPollAnswer>): String {
        return EkoGson.get().toJson(list)
    }
}