package com.ekoapp.ekosdk.internal.data.converter;

import androidx.room.TypeConverter;

import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.google.gson.reflect.TypeToken;

import java.util.List;

public class StringListConverter {

    @TypeConverter
    public List<String> stringToStringList(String json) {
        return EkoGson.get().fromJson(json, new TypeToken<List<String>>(){}.getType());
    }

    @TypeConverter
    public String stringListToString(List<String> list) {
        return EkoGson.get().toJson(list);
    }

}
