package com.ekoapp.ekosdk.internal.data.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.social.comment.AmityCommentSortOption
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.entity.CommentEntity
import com.ekoapp.ekosdk.internal.keycreator.CommentKeyCreator
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface AmityCommentPagingDao : DynamicQueryStreamPagingDao<CommentEntity> {

    @RawQuery(observedEntities = [CommentEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, CommentEntity>

    fun getCommentPagingSource(
        referenceId: String,
        referenceType: String,
        isFilterByParentId: Boolean,
        parentId: String?,
        isDeleted: Boolean?,
        sortOption: AmityCommentSortOption
    ): PagingSource<Int, CommentEntity> {
        val order = if (AmityCommentSortOption.LAST_CREATED == sortOption)
            AmityPagingDao.Order.DESC else AmityPagingDao.Order.ASC
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "comment",
                primaryKeyColumnName = "commentId",
                additionalPrimaryKeys = emptyMap(),
                dynamicQueryStreamKeyCreator = CommentKeyCreator(
                    referenceId = referenceId,
                    referenceType = referenceType,
                    parentId = parentId,
                    isDeleted = isDeleted,
                    sortOption = sortOption
                ),
                nonce = AmityNonce.COMMENT_LIST,
                order = order,
                sortColumn = "createdAt",
            )
        )
    }
}