package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import com.ekoapp.ekosdk.internal.data.model.*
import io.reactivex.Completable
import io.reactivex.Maybe

@Dao
abstract class AmityCommunityCategoryQueryTokenDao  : AmityPagingTokenDao<EkoCommunityCategoryQueryToken> {

    @RawQuery(observedEntities = [EkoCommunityCategoryQueryToken::class])
    abstract override fun queryToken(query: SimpleSQLiteQuery): Maybe<EkoCommunityCategoryQueryToken>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract override fun insertToken(token: EkoCommunityCategoryQueryToken): Completable

    override fun tableName() = COMMUNITY_CATEGORY_QUERY_TOKEN_TABLE_NAME
}