package com.ekoapp.ekosdk.internal.data.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.social.community.AmityCommunityFilter
import com.amity.socialcloud.sdk.social.community.AmityCommunitySortOption
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.entity.CommunityEntity

@Dao
internal interface AmityCommunityPagingDao : AmityPagingDao<CommunityEntity> {

    @RawQuery(observedEntities = [CommunityEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, CommunityEntity>

    fun queryCommunities(
        keyword: String,
        categoryId: String,
        filter: AmityCommunityFilter,
        sortBy: AmityCommunitySortOption,
        isDeleted: Boolean?
    ): PagingSource<Int, CommunityEntity> {
        return queryPagingData(
            generateSqlQuery(
                tableName = "community",
                primaryKeyColumnName = "communityId",
                queryParameters = mapOf(
                    "keyword" to keyword,
                    "categoryId" to categoryId,
                    "filter" to filter.value,
                    "sortBy" to sortBy.apiKey,
                    "isDeleted" to (isDeleted ?: false)
                ),
                nonce = AmityNonce.COMMUNITY_LIST, order = AmityPagingDao.Order.ASC
            )
        )
    }
}