package com.ekoapp.ekosdk.internal.data.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.entity.EkoStreamEntity
import com.ekoapp.ekosdk.internal.keycreator.StreamKeyCreator
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagingDao

@Dao
internal interface AmityStreamPagingDao : DynamicQueryStreamPagingDao<EkoStreamEntity> {

    @RawQuery(observedEntities = [EkoStreamEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, EkoStreamEntity>
    
    fun queryStreamList(
        statuses: List<String>
    ): PagingSource<Int, EkoStreamEntity> {
        return queryPagingData(
                generateQueryStreamSQL(
                        tableName = "stream",
                        primaryKeyColumnName = "streamId",
                        dynamicQueryStreamKeyCreator = StreamKeyCreator(statuses),
                        nonce = AmityNonce.STREAM_LIST,
                        order = AmityPagingDao.Order.ASC
                )
        )
    }
}