package com.ekoapp.ekosdk.internal.data.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.social.feed.AmityPost
import com.amity.socialcloud.sdk.social.feed.AmityUserFeedSortOption
import com.ekoapp.ekosdk.internal.PostEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator
import com.ekoapp.ekosdk.internal.keycreator.UserPostKeyCreator
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao

@Dao
internal interface AmityUserPostPagingDao : DynamicQueryStreamPagingDao<PostEntity> {

    @RawQuery(observedEntities = [PostEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, PostEntity>

    fun getUserFeedPagingSource(
        userId: String,
        includeDeleted: Boolean?,
        sortBy: String,
        postTypes: List<AmityPost.DataType>
    ): PagingSource<Int, PostEntity> {
        val order = if (AmityUserFeedSortOption.LAST_CREATED.apiKey == sortBy)
            AmityPagingDao.Order.DESC else AmityPagingDao.Order.ASC
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "post",
                primaryKeyColumnName = "postId",
                additionalPrimaryKeys = emptyMap(),
                dynamicQueryStreamKeyCreator = UserPostKeyCreator(
                    userId = userId,
                    sortBy = sortBy,
                    isDeleted = includeDeleted,
                    postTypes = postTypes
                ),
                nonce = AmityNonce.USER_FEED,
                order = order,
                sortColumn = "createdAt",
            )
        )
    }
}