package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.ChatSettingsEntity
import io.reactivex.Flowable


@Dao
abstract class ChatSettingsDao : EkoObjectDao<ChatSettingsEntity>() {

    @Query("select * from chat_settings where settingId = :settingId")
    abstract fun getChatSettings(settingId: String): Flowable<ChatSettingsEntity>

    @Query("DELETE from chat_settings")
    abstract override fun deleteAll()
}