package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.*
import androidx.sqlite.db.SimpleSQLiteQuery
import com.ekoapp.ekosdk.internal.data.model.COMMUNITY_FEED_QUERY_TOKEN_TABLE_NAME
import com.ekoapp.ekosdk.internal.data.model.CommunityFeedQueryTokenEntity
import io.reactivex.Completable
import io.reactivex.Maybe

@Dao
abstract class CommunityFeedQueryTokenDao : AmityPagingTokenDao<CommunityFeedQueryTokenEntity> {

    @RawQuery(observedEntities = [CommunityFeedQueryTokenEntity::class])
    abstract override fun queryToken(query: SimpleSQLiteQuery): Maybe<CommunityFeedQueryTokenEntity>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract override fun insertToken(token: CommunityFeedQueryTokenEntity): Completable

    override fun tableName() = COMMUNITY_FEED_QUERY_TOKEN_TABLE_NAME
}