package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import com.ekoapp.ekosdk.internal.data.model.COMMUNITY_MEMBER_QUERY_TOKEN_TABLE_NAME
import com.ekoapp.ekosdk.internal.data.model.CommunityMemberQueryTokenEntity
import io.reactivex.Completable
import io.reactivex.Maybe


@Dao
abstract class CommunityMemberQueryTokenDao : AmityPagingTokenDao<CommunityMemberQueryTokenEntity> {

    @RawQuery(observedEntities = [CommunityMemberQueryTokenEntity::class])
    abstract override fun queryToken(query: SimpleSQLiteQuery): Maybe<CommunityMemberQueryTokenEntity>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract override fun insertToken(token: CommunityMemberQueryTokenEntity): Completable

    override fun tableName() = COMMUNITY_MEMBER_QUERY_TOKEN_TABLE_NAME

}