package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;

import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;

@Dao
public abstract class EkoApiKeyDao {

    @Query("SELECT * from api_key LIMIT 1")
    public abstract Flowable<EkoApiKey> getCurrentApiKeyFlowable();

    @Query("SELECT * from api_key LIMIT 1")
    public abstract Maybe<EkoApiKey> getCurrentApiKey();

    @Query("SELECT * from api_key LIMIT 1")
    public abstract Single<EkoApiKey> getCurrentApiKeySingle();

    @Query("SELECT * from api_key LIMIT 1")
    public abstract EkoApiKey getCurrentApiKeyNow();

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insert(EkoApiKey apiKey);
}
