package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;

import com.ekoapp.ekosdk.EkoChannelExtra;
import com.ekoapp.ekosdk.EkoChannelReadStatus;
import com.ekoapp.ekosdk.internal.EkoChannelEntity;

import java.util.List;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;


@Dao
public abstract class EkoChannelExtraDao extends EkoObjectDao<EkoChannelExtra> {

    @Query("SELECT * from channel_extra where channelId = :id LIMIT 1")
    public abstract Flowable<EkoChannelExtra> getById(String id);

    @Query("SELECT * from channel_extra where channelId = :id LIMIT 1")
    public abstract EkoChannelExtra getByIdNow(String id);

    @Query("SELECT channelId from channel_extra where readStatus = :readStatus")
    public abstract Single<List<String>> getAllIdsByReadStatus(EkoChannelReadStatus readStatus);

    @Transaction
    public void insertOrUpdate(String id) {
        EkoChannelExtra extra = getByIdNow(id);
        if (extra != null) {
            update(extra);
        } else {
            insert(new EkoChannelExtra(id));
        }
    }

    @Transaction
    public void insertOrUpdate(List<String> ids) {
        for(String id : ids) {
            insertOrUpdate(id);
        }
    }

    @Query("UPDATE channel_extra set readStatus = :status where readStatus != :status")
    public abstract void updateAllReadStatuses(EkoChannelReadStatus status);

    @Query("UPDATE channel_extra set readStatus = :readMode where channelId = :id")
    public abstract void updateReadStatus(String id, EkoChannelReadStatus readMode);

    @Query("UPDATE channel_extra set localReadToSegment = :localReadToSegment where channelId = :channelId and localReadToSegment < :localReadToSegment")
    public abstract void updateLocalReadToSegment(String channelId, int localReadToSegment);

    @Query("UPDATE channel_extra set localLastMentionedSegment = :localLastMentionedSegment where channelId = :channelId and localLastMentionedSegment < :localLastMentionedSegment")
    public abstract void updateLocalLastMentionedSegment(String channelId, int localLastMentionedSegment);

    @Query("DELETE from channel_extra")
    public abstract void deleteAll();

    @Query("DELETE from channel_extra where channelId = :channelId")
    public abstract void deleteAllFromChannel(String channelId);
}
