package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import com.ekoapp.ekosdk.internal.data.model.CHANNEL_MEMBERSHIP_QUERY_TOKEN_TABLE_NAME
import com.ekoapp.ekosdk.internal.data.model.EkoChannelMembershipQueryToken
import com.ekoapp.ekosdk.internal.data.model.UserQueryTokenEntity
import io.reactivex.Completable
import io.reactivex.Maybe

@Dao
abstract class EkoChannelMembershipQueryTokenDao : AmityPagingTokenDao<EkoChannelMembershipQueryToken> {

    @RawQuery(observedEntities = [UserQueryTokenEntity::class])
    abstract override fun queryToken(query: SimpleSQLiteQuery): Maybe<EkoChannelMembershipQueryToken>

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract override fun insertToken(token: EkoChannelMembershipQueryToken): Completable

    override fun tableName() = CHANNEL_MEMBERSHIP_QUERY_TOKEN_TABLE_NAME
}