package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Query;

import com.amity.socialcloud.sdk.social.community.AmityCommunityCategorySortOption;
import com.ekoapp.ekosdk.community.category.CommunityCategoryEntity;

import java.util.List;

@Dao
public abstract class EkoCommunityCategoryDao extends EkoObjectDao<CommunityCategoryEntity> {

    @Delete
    public abstract void delete(CommunityCategoryEntity category);

    @Query("DELETE from community_category")
    public abstract void deleteAll();

    @Query("SELECT *" +
            " from community_category" +
            " where community_category.isDeleted = " +
            "(case when :isDeleted is null then isDeleted else :isDeleted end)" +
            " order by case when :isSortByName = 1 then community_category.name end asc," +
            " case when :isSortByName = 0 and :isSortByCreatedACS = 1 then community_category.createdAt end asc," +
            " case when :isSortByName = 0 and :isSortByCreatedACS = 0 then community_category.createdAt end desc")
    abstract DataSource.Factory<Integer, CommunityCategoryEntity> getAllImpl(
            boolean isSortByName,
            boolean isSortByCreatedACS,
            Boolean isDeleted);

    public DataSource.Factory<Integer, CommunityCategoryEntity> getAll(AmityCommunityCategorySortOption sortBy, Boolean isDeleted) {
        return getAllImpl(
                isSortByName(sortBy),
                isSortByCreatedACS(sortBy),
                isDeleted)
                .map(input -> input);
    }

    private Boolean isSortByName(AmityCommunityCategorySortOption sortBy) {
        return sortBy == AmityCommunityCategorySortOption.NAME;
    }

    private Boolean isSortByCreatedACS(AmityCommunityCategorySortOption sortBy) {
        return sortBy == AmityCommunityCategorySortOption.FIRST_CREATED;
    }

    @Query("SELECT *" +
            " from community_category" +
            " where community_category.categoryId IN (:ids)")
    abstract List<CommunityCategoryEntity> getByIdsNowImpl(List<String> ids);

    @Override
    public List<CommunityCategoryEntity> getByIdsNow(List<String> ids) {
        return getByIdsNowImpl(ids);
    }

    @Query("SELECT *" +
            " from community_category" +
            " where community_category.isDeleted = " +
            "(case when :isDeleted is null then isDeleted else :isDeleted end)" +
            " order by case when :isSortByName = 1 then community_category.name end asc," +
            " case when :isSortByName = 0 and :isSortByCreatedACS = 1 then community_category.createdAt end asc," +
            " case when :isSortByName = 0 and :isSortByCreatedACS = 0 then community_category.createdAt end desc")
    abstract PagingSource<Integer, CommunityCategoryEntity> getPagingSourceImpl(
            boolean isSortByName,
            boolean isSortByCreatedACS,
            Boolean isDeleted);

    public PagingSource<Integer, CommunityCategoryEntity> getPagingSource(AmityCommunityCategorySortOption sortBy, Boolean isDeleted) {
        return getPagingSourceImpl(isSortByName(sortBy),
                isSortByCreatedACS(sortBy),
                isDeleted);
    }
}