package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.Dao;
import androidx.room.Query;

import com.ekoapp.ekosdk.internal.entity.FeedEntity;

import java.util.List;

import io.reactivex.rxjava3.core.Flowable;

@Dao
public abstract class EkoFeedDao extends EkoObjectDao<FeedEntity> {

    @Query("DELETE from feed")
    public abstract void deleteAll();

    @Query("SELECT *" +
            " from feed" +
            " where feed.feedId = :feedId" +
            " LIMIT 1")
    abstract FeedEntity getByIdNowImpl(String feedId);

    @NonNull
    public FeedEntity getByIdNow(@NonNull String feedId) {
        return getByIdNowImpl(feedId);
    }

    @Query("SELECT *" +
            " from feed" +
            " where feed.feedId IN (:ids)")
    abstract List<FeedEntity> getByIdsNowImpl(List<String> ids);

    @NonNull
    @Override
    public List<FeedEntity> getByIdsNow(@NonNull List<String> ids) {
        return getByIdsNowImpl(ids);
    }

    @Query("SELECT *" +
            " from feed" +
            " where feed.targetId = :targetId" +
            " and feed.feedType = :feedType")
    abstract Flowable<FeedEntity> getCommunityFeedImpl(String targetId, String feedType);

    public Flowable<FeedEntity> getCommunityFeed(String targetId, String feedType) {
        return getCommunityFeedImpl(targetId, feedType);
    }

}
