package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.Dao;
import androidx.room.Query;

import com.ekoapp.ekosdk.internal.EkoFileEntity;

import java.util.List;

@Dao
public abstract class EkoFileDao extends EkoObjectDao<EkoFileEntity> {


    @Query("DELETE from file")
    public abstract void deleteAll();

    @Query("SELECT *" +
            " from file" +
            " where file.fileId = :fileId" +
            " LIMIT 1")
    abstract EkoFileEntity getByIdNowImpl(String fileId);

    public EkoFileEntity getByIdNow(@NonNull String fileId) {
        return getByIdNowImpl(fileId);
    }

    @Query("SELECT *" +
            " from file" +
            " where file.fileId IN (:ids)")
    abstract List<EkoFileEntity> getByIdsNowImpl(List<String> ids);

    @NonNull
    @Override
    public List<EkoFileEntity> getByIdsNow(@NonNull List<String> ids) {
        return getByIdsNowImpl(ids);
    }

}
