package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl;

import io.reactivex.Flowable;
import io.reactivex.Maybe;


@Dao
public abstract class EkoHttpUrlDao {

    @Query("SELECT * from http_url LIMIT 1")
    public abstract Flowable<EkoHttpUrl> observeCurrentHttpUrl();

    @Query("SELECT * from http_url LIMIT 1")
    public abstract Maybe<EkoHttpUrl> getCurrentHttpUrl();

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insert(EkoHttpUrl url);
}
