package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;

import com.ekoapp.ekosdk.internal.data.model.EkoMessageFlag;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;


@Dao
public abstract class EkoMessageFlagDao extends EkoObjectDao<EkoMessageFlag> {

    @Query("DELETE from message_flag")
    public abstract void deleteAll();

    @Query("SELECT * from message_flag where messageId = :messageId LIMIT 1")
    abstract EkoMessageFlag getByIdNowImpl(String messageId);

    public EkoMessageFlag getByIdNow(String messageId) {
        return getByIdNowImpl(messageId);
    }

    @Query("SELECT *" +
            " from message_flag" +
            " where message_flag.messageId = :messageId" +
            " LIMIT 1")
    abstract Flowable<EkoMessageFlag> getByMessageIdImpl(String messageId);

    public Flowable<EkoMessageFlag> getByMessageId(String messageId) {
        return getByMessageIdImpl(messageId);
    }

}
