package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Query;

import com.ekoapp.ekosdk.internal.data.model.EkoPostFlag;

import io.reactivex.Flowable;

@Dao
public abstract class EkoPostFlagDao extends EkoObjectDao<EkoPostFlag> {

    @Query("DELETE from post_flag")
    public abstract void deleteAll();

    @Query("SELECT * from post_flag where postId = :postId LIMIT 1")
    abstract EkoPostFlag getByIdNowImpl(String postId);

    public EkoPostFlag getByIdNow(String postId) {
        return getByIdNowImpl(postId);
    }

    @Query("SELECT *" +
            " from post_flag" +
            " where post_flag.postId = :postId" +
            " LIMIT 1")
    abstract Flowable<EkoPostFlag> getByPostIdImpl(String postId);

    public Flowable<EkoPostFlag> getByPostId(String postId) {
        return getByPostIdImpl(postId);
    }

}
