package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ekoapp.ekosdk.internal.data.model.EkoPushConfig;

import io.reactivex.Flowable;

@Dao
public abstract class EkoPushConfigDao {

    @Query("SELECT count(*) from push_config where state = 'registered'")
    abstract Flowable<Integer> countRegisteredConfig();

    public Flowable<Boolean> hasRegisteredConfig() {
        return countRegisteredConfig()
                .map(count -> count > 0)
                .distinctUntilChanged();
    }

    @Query("SELECT * from push_config where userId = :userId LIMIT 1")
    public abstract Flowable<EkoPushConfig> getPushConfig(String userId);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insert(EkoPushConfig pushConfig);

    @Query("UPDATE push_config set state = 'unregistered'")
    public abstract void unregisterAll();

    @Query("DELETE FROM push_config WHERE userId = :userId and state = 'unregistered'")
    public abstract void clearUnregisteredPushConfigForUser(String userId);
}
