package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.paging.DataSource;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;

import com.ekoapp.ekosdk.internal.entity.EkoStreamEntity;

import org.joda.time.DateTime;

import java.util.List;

import io.reactivex.rxjava3.core.Flowable;

@Dao
public abstract class EkoStreamDao extends EkoObjectDao<EkoStreamEntity> {


    @Query("SELECT * from stream where status in (:statuses) and isDeleted = 0 order by createdAt DESC")
    abstract DataSource.Factory<Integer, EkoStreamEntity> getAllImpl(String[] statuses);

    public DataSource.Factory<Integer, EkoStreamEntity> getAll(String[] statuses) {
        return getAllImpl(statuses);
    }

    @Query("SELECT * from stream where streamId = :streamId")
    abstract Flowable<EkoStreamEntity> getByIdImpl(String streamId);

    public Flowable<EkoStreamEntity> getById(String streamId) {
        return getByIdImpl(streamId);
    }

    @Query("SELECT * from stream where streamId = :streamId")
    abstract EkoStreamEntity getByIdNowImpl(String streamId);

    public EkoStreamEntity getByIdNow(@NonNull String streamId) {
        return getByIdNowImpl(streamId);
    }

    @Query("UPDATE stream set isDeleted = 1 where isDeleted = 0")
    abstract void softDeleteImpl();

    @Transaction
    public void softDelete() {
        softDeleteImpl();
    }

    @Query("DELETE from stream")
    public abstract void deleteAll();

    public Flowable<EkoStreamEntity> getLatestStream(List<String> statuses) {
        return getLatestStreamImpl(statuses, DateTime.now());
    }

    @Query("SELECT * from stream where status in (:statuses)" +
            " and stream.updatedAt > :now" +
            " order by stream.updatedAt DESC" +
            " limit 1")
    abstract Flowable<EkoStreamEntity> getLatestStreamImpl(List<String> statuses, DateTime now);
}
