package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;

import com.ekoapp.ekosdk.stream.StreamSessionSyncState;
import com.ekoapp.ekosdk.stream.entity.EkoStreamSessionEntity;

import java.util.List;

import io.reactivex.rxjava3.core.Flowable;

@Dao
public abstract class EkoStreamSessionDao extends EkoObjectDao<EkoStreamSessionEntity> {


    @Query("SELECT * from stream_session where syncState in (:syncStates) AND watchSeconds > 0 order by startTime DESC")
    abstract Flowable<List<EkoStreamSessionEntity>> getAllImpl(String[] syncStates);

    public Flowable<List<EkoStreamSessionEntity>> getAll(String[] syncStates) {
        return getAllImpl(syncStates);
    }

    @Query("SELECT * from stream_session where sessionId = :sessionId")
    abstract Flowable<EkoStreamSessionEntity> getByIdImpl(String sessionId);

    public Flowable<EkoStreamSessionEntity> getById(String sessionId) {
        return getByIdImpl(sessionId);
    }

    @Query("UPDATE stream_session set syncState = :toState where syncState = :fromState")
    abstract void updateSyncStateImpl(String fromState, String toState);

    @Transaction
    public void updateSyncState(StreamSessionSyncState fromState, StreamSessionSyncState toState) {
        updateSyncStateImpl(fromState.getKey(), toState.getKey());
    }

    @Query("DELETE from stream_session")
    public abstract void deleteAll();
}
